﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;

namespace DataTemplateTrigger
{
  public enum TaskType
  {
    Home,
    Work,
    Other
  }

  public class Task : INotifyPropertyChanged
  {
    private string strName;
    private string strDescription;
    private int iPriority;
    private TaskType taskType;

    #region INotifyPropertyChanged Members

    public event PropertyChangedEventHandler PropertyChanged;

    #endregion

    public Task()
    {
    }

    public Task(string name, string description, int priority, TaskType type)
    {
      this.strName = name;
      this.strDescription = description;
      this.iPriority = priority;
      this.taskType = type;
    }

    public string TaskName
    {
      get { return strName; }
      set
      {
        strName = value;
        OnPropertyChanged("TaskName");
      }
    }

    public string Description
    {
      get { return strDescription; }
      set
      {
        strDescription = value;
        OnPropertyChanged("Description");
      }
    }

    public int Priority
    {
      get { return iPriority; }
      set
      {
        iPriority = value;
        OnPropertyChanged("Priority");
      }
    }

    public TaskType TaskType
    {
      get { return taskType; }
      set
      {
        taskType = value;
        OnPropertyChanged("TaskType");
      }
    }

    protected void OnPropertyChanged(string info)
    {
      PropertyChangedEventHandler handler = PropertyChanged;

      if (handler != null)
      {
        handler(this, new PropertyChangedEventArgs(info));
      }
    }
  }
}
